#ifndef _RESOURCES_HLSL_
#define _RESOURCES_HLSL_

cbuffer frameParams : register(b0)
{
  float4   camPos;
  float4   camTarget;
  float4   camParams; // x: xScale factor,    y: yScale factor,   z: zFar / (zFar - zNear), w: z * zNear
  float4x4 viewM;
  float4   lightDir;
  float4   params;    // x: time in seconds, 
};


//
// Textures
//
#define MAX_TEXTURES 2
#define MAX_SAMPLERS 2

SamplerState SAMPLERS[MAX_SAMPLERS] : register(s0);
Texture2D TEXTURES[MAX_TEXTURES] : register(t0);


//
// Bboxes
//
// Bounding-box declaration
struct BoundingBox
{
  float4x4 txx;
  //float4x4 txi;
  float4   rad;
};

// Array of bounding boxes for scene nodes
//static BoundingBox _gBoundingBoxes[NODE_COUNT];
// Node positions
static float3 gPositions[MAX_NODES_COUNT];
// Node positions
static float3 gSizes[MAX_NODES_COUNT];
// Colors for bounding-boxes visualization
//static float3 _gColors[NODE_COUNT];

cbuffer boxesParams : register(b1)
{
  // FIXME: vvvv don't recognize structs as input params
  //float4x4 txx[MAX_NODES_COUNT];
  //float4   rad[MAX_NODES_COUNT];
  BoundingBox gBoundingBoxes[MAX_NODES_COUNT];
  float4 gColors[MAX_NODES_COUNT];
};



#endif